@extends('admin.layout.page-app')
@section('page_title', __('label.ultimate_challenges'))
@section('tab_title', __('label.ultimate_challenges'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.ultimate_challenges')}}</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('label.ultimate_challenges')}}</li>
                    </ol>
                </div>
            </div>

            <!-- Add Ultimate Challenges -->
            <div class="card custom-border-card mt-3">
                <h5 class="card-header">{{__('label.add_ultimate_challenges')}}</h5>
                <div class="card-body">
                    <form id="ultimate_challenges" enctype="multipart/form-data">
                        <input type="hidden" name="id" value="">
                        <div class="form-row">
                            <div class="col-md-9">
                                <div class="form-row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>{{__('label.name')}}<span class="text-danger">*</span></label>
                                            <input name="name" type="text" class="form-control" placeholder="{{__('label.name_here')}}" autofocus>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>{{__('label.start_date')}}<span class="text-danger">*</span></label>
                                            <input name="start_date" type="date" class="form-control" min="{{ date('Y-m-d') }}">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>{{__('label.end_date')}}<span class="text-danger">*</span></label>
                                            <input name="end_date" type="date" class="form-control" min="{{ date('Y-m-d') }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>{{__('label.total_questions')}}<span class="text-danger">*</span></label>
                                            <input type="number" name="total_questions" min="1" class="form-control" placeholder="{{__('label.total_questions_here')}}">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>{{__('label.duration_per_question')}}<span class="text-danger">*</span></label>
                                            <input type="number" name="quiz_duration" min="1" class="form-control" placeholder="{{__('label.seconds_here')}}">
                                        </div>
                                    </div>
        							<div class="col-md-3">
                                        <div class="form-group">
                                            <label>{{__('label.min_winning_percentage')}}<span class="text-danger">*</span></label>
                                            <input type="number" name="min_winning_percentage" min="0" class="form-control" placeholder="{{__('label.percentage_here')}}">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
							        	<div class="form-group">
									        <label>{{__('label.winning_coin')}}<span class="text-danger">*</span></label>
									        <input type="number" name="winning_coin" min="0" class="form-control" placeholder="{{__('label.coin_here')}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>{{__('label.is_paid')}}<span class="text-danger">*</span></label>
                                            <div class="radio-group">
                                                <div class="custom-control custom-radio">
                                                    <input type="radio" name="is_paid" id="is_paid_no" class="custom-control-input" value="0" checked>
                                                    <label class="custom-control-label" for="is_paid_no">{{__('label.no')}}</label>
                                                </div>
                                                <div class="custom-control custom-radio">
                                                    <input type="radio" name="is_paid" id="is_paid_yes" class="custom-control-input" value="1">
                                                    <label class="custom-control-label" for="is_paid_yes">{{__('label.yes')}}</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 joining_coin_box">
                                        <div class="form-group">
                                            <label>{{__('label.joining_coin')}}<span class="text-danger">*</span></label>
                                            <input type="number" name="joining_coin" min="1" class="form-control" placeholder="{{__('label.coin_here')}}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group ml-5">
                                    <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                    <div class="avatar-upload">
                                        <div class="avatar-edit">
                                            <input type='file' name="image" id="imageUpload1" accept=".png, .jpg, .jpeg" />
                                            <label for="imageUpload1" title="{{__('label.upload_file')}}"></label>
                                        </div>
                                        <div class="avatar-preview">
                                            <img src="{{ asset('assets/imgs/upload_img.png') }}" id="imagePreview1">
                                        </div>
                                    </div>
                                    <label class="mt-3 text-gray">{{__('label.max_size_5mb')}}</label>
                                </div>
                            </div>
                        </div>
                        <div class="border-top pt-3 text-right">
                            <button type="button" class="btn btn-default mw-120" onclick="save_ultimate_challenges()">{{__('label.save')}}</button>
                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        </div>
                    </form>
                </div>
            </div>

            <!-- Search && Table -->
            <div class="card custom-border-card mt-3">
                <div class="page-search mb-3">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1"><i class="fa-solid fa-magnifying-glass fa-xl"></i></span>
                        </div>
                        <input type="text" id="input_search" class="form-control" placeholder="{{__('label.search')}}" aria-label="Search" aria-describedby="basic-addon1">
                    </div>
                </div>

                <div class="table-responsive table">
                    <table class="table table-striped text-center table-bordered" id="datatable">
                        <thead>
                            <tr>
                                <th>{{__('label.#')}}</th>
                                <th>{{__('label.image')}}</th>
                                <th>{{__('label.name')}}</th>
                                <th>{{__('label.date')}}</th>
                                <th>{{__('label.total_questions')}}</th>
                                <th>{{__('label.is_paid')}}</th>
                                <th>{{__('label.winning_coin')}}</th>
                                <th>{{__('label.status')}}</th>
                                <th>{{__('label.action')}}</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>

            <!-- Edit Model -->
            <div class="modal fade" id="EditModel" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">{{__('label.edit_ultimate_challenges')}}</h5>
                            <button type="button" class="close text-dark" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form id="edit_ultimate_challenges" enctype="multipart/form-data">
                            <div class="modal-body">
                                <input type="hidden" name="id" id="edit_id">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>{{__('label.name')}}<span class="text-danger">*</span></label>
                                                    <input type="text" name="name" id="edit_name" class="form-control" placeholder="{{__('label.name_here')}}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>{{__('label.start_date')}}<span class="text-danger">*</span></label>
                                                    <input name="start_date" id="edit_start_date" type="date" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>{{__('label.end_date')}}<span class="text-danger">*</span></label>
                                                    <input name="end_date" id="edit_end_date" type="date" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>{{__('label.total_questions')}}<span class="text-danger">*</span></label>
                                                    <input type="number" name="total_questions" id="edit_total_questions" min="1" class="form-control" placeholder="{{__('label.total_questions_here')}}">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>{{__('label.duration_per_question')}}<span class="text-danger">*</span></label>
                                                    <input type="number" name="quiz_duration" id="edit_quiz_duration" min="1" class="form-control" placeholder="{{__('label.seconds_here')}}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>{{__('label.min_winning_percentage')}}<span class="text-danger">*</span></label>
                                                    <input type="number" name="min_winning_percentage" id="edit_min_winning_percentage" min="0" class="form-control" placeholder="{{__('label.percentage_here')}}">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>{{__('label.winning_coin')}}<span class="text-danger">*</span></label>
                                                    <input type="number" name="winning_coin" id="edit_winning_coin" min="0" class="form-control" placeholder="{{__('label.coin_here')}}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>{{__('label.is_paid')}}<span class="text-danger">*</span></label>
                                                    <div class="radio-group">
                                                        <div class="custom-control custom-radio">
                                                            <input type="radio" name="is_paid" id="edit_is_paid_no" class="custom-control-input" value="0">
                                                            <label class="custom-control-label" for="edit_is_paid_no">{{__('label.no')}}</label>
                                                        </div>
                                                        <div class="custom-control custom-radio">
                                                            <input type="radio" name="is_paid" id="edit_is_paid_yes" class="custom-control-input" value="1">
                                                            <label class="custom-control-label" for="edit_is_paid_yes">{{__('label.yes')}}</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6 joining_coin_box">
                                                <div class="form-group">
                                                    <label>{{__('label.joining_coin')}}<span class="text-danger">*</span></label>
                                                    <input type="number" name="joining_coin" id="edit_joining_coin" min="1" class="form-control" placeholder="{{__('label.coin_here')}}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-3">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="image" id="imageUpload2" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageUpload2" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="" id="imagePreview2">
                                                </div>
                                            </div>
                                            <label class="mt-3 text-gray">{{__('label.max_size_5mb')}}</label>
                                            <input type="hidden" name="old_image" id="edit_old_image">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default mw-120" onclick="update_ultimate_challenges()">{{__('label.update')}}</button>
                                <button type="button" class="btn btn-cancel mw-120" data-dismiss="modal">{{__('label.close')}}</button>
                                <input type="hidden" name="_method" value="PATCH">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <script>
        $(document).ready(function () {

            toggleJoiningCoinBox();
            $(document).on('change', 'input[name="is_paid"]', function () {
                toggleJoiningCoinBox();
            });

            function toggleJoiningCoinBox() {
                let isPaidAdd = $('input[name="is_paid"]:checked').val();
                if (isPaidAdd == 1) {
                    $('.joining_coin_box').show();
                } else {
                    $('.joining_coin_box').hide();
                }

                let isPaidEdit = $('#edit_is_paid_yes').is(':checked');
                if (isPaidEdit) {
                    $('#edit_joining_coin').closest('.joining_coin_box').show();
                } else {
                    $('#edit_joining_coin').closest('.joining_coin_box').hide();
                }
            }
        });
        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                ...dataTableDefaults,
                ajax:
                    {
                    url: "{{ route('admin.ultimatechallenge.index') }}",
                    data: function(d){
                        d.input_search = $('#input_search').val();
                    },
                },
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false},
                    {
						data: 'image',
						name: 'image',
						orderable: false,
						searchable: false,
						render: function(data, type, full, meta) {
                            return `<a href='${data}' target='_blank'>
                                        <img src='${data}' class='img-thumbnail' style='height:55px; width:55px'>
                                    </a>`;
						},
					},
                    {
                        data: 'name',
                        name: 'name',
                        render: function(data) {
                            return data ? data : "-";
                        }
                    },
                    {
                        data: 'date',
                        name: 'date',
                        render: function(data, type, row) {
                            const start = row.start_date ? row.start_date : '';
                            const end = row.end_date ? row.end_date : '';
                            return `<div style="font-size: 14px; font-weight: 600;">${start}<br>{{__('label.to')}}<br>${end}</div>`;
                        }
                    },
                    {
                        data: 'total_questions',
                        name: 'total_questions',
                        render: function(data) {
                            return `<span style="font-size: 20px; font-weight: 600;">${data ?? 0}</span>`;
                        }
                    },
                    {
                        data: 'is_paid',
                        name: 'is_paid',
                        render: function(data, type, row) {
                            if (row.is_paid == 1) {
                                return `<div style="text-align: left;">
                                    <span style="font-weight: bold" class="red-color">{{__('label.paid')}}</span><br>
                                    <span style="font-weight: bold" class="primary-color">{{__('label.coin')}} : ${row.joining_coin || 0}</span></div>`;
                            } else {
                                return `<div style="text-align: left; font-weight: bold;" class="green-color">{{__('label.free')}}</div>`;
                            }
                        }
                    },
                    {
                        data: 'winning_coin',
                        name: 'winning_coin',
                        render: function(data) {
                            return `<span style="font-size: 20px; font-weight: 600;" class="primary-color">${data ?? 0}<i class="fa-solid fa-sack-dollar ml-3 fa-lg"></i></span>`;
                        }
                    },
                    {
						data: 'status',
						name: 'status',
                        orderable: false,
						searchable: false,
					},
					{ data: 'action', name: 'action', orderable: false, searchable: false }
                ],
            });

            $('#input_search').keyup(function() {
                table.draw();
            });
        });

        function save_ultimate_challenges(){

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                $("#dvloader").show();
                var formData = new FormData($("#ultimate_challenges")[0]);
                $.ajax({
                    type:'POST',
                    url:'{{ route("admin.ultimatechallenge.store") }}',
                    data:formData,
                    cache:false,
                    contentType: false,
                    processData: false,
                    success:function(resp){
                        $("#dvloader").hide();
                        get_responce_message(resp, 'ultimate_challenges', '{{ route("admin.ultimatechallenge.index") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
		}

        $(document).on("click", ".edit_ultimate_challenge", function() {
            var id = $(this).data('id');
            var name = $(this).data('name');
            var image = $(this).data('image');
            var start_date = $(this).data('start_date');
            var end_date = $(this).data('end_date');
            var total_questions = $(this).data('total_questions');
            var quiz_duration = $(this).data('quiz_duration');
            var is_paid = $(this).data('is_paid');
            var joining_coin = $(this).data('joining_coin');
            var min_winning_percentage = $(this).data('min_winning_percentage');
            var winning_coin = $(this).data('winning_coin');

            $(".modal-body #edit_id").val(id);
            $(".modal-body #edit_name").val(name);
            $(".modal-body #edit_start_date").val(start_date);
            $(".modal-body #edit_end_date").val(end_date);
            $(".modal-body #edit_total_questions").val(total_questions);
            $(".modal-body #edit_quiz_duration").val(quiz_duration);
            $(".modal-body #edit_min_winning_percentage").val(min_winning_percentage);
            $(".modal-body #edit_winning_coin").val(winning_coin);
            $(".modal-body #edit_joining_coin").val(joining_coin);
            $(".modal-body #imagePreview2").attr("src", image);
            $(".modal-body #edit_old_image").val(image);
            $(".modal-body input[name='is_paid']").each(function() {
                $(this).prop("checked", $(this).val() == is_paid);
            });
            if (is_paid == 1) {
                $(".modal-body .joining_coin_box").show();
            } else if(is_paid == 0) {
                $(".modal-body .joining_coin_box").hide();
            }
        });
        function update_ultimate_challenges() {

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                $("#dvloader").show();
                var formData = new FormData($("#edit_ultimate_challenges")[0]);
                
                var Edit_Id = $("#edit_id").val();
                var url = '{{ route("admin.ultimatechallenge.update", ":id") }}';
                    url = url.replace(':id', Edit_Id);

                $.ajax({
                    type: 'POST',
                    url: url,
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {

                        $("#dvloader").hide();
                        if(resp.status == 200){
                            $('#EditModel').modal('toggle');
                        }
                        get_responce_message(resp, 'edit_ultimate_challenges', '{{ route("admin.ultimatechallenge.index") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        }

        function change_status(id) {

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                $("#dvloader").show();
                var url = `{{ route('admin.ultimatechallenge.show', '') }}/${id}`;

                $.ajax({
                    type: "GET",
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(resp) {
                        $("#dvloader").hide();

                        if (resp.status == 200) {
                            if (resp.status_code == 1) {
                                $('#' + id).text('{{__("label.active")}}').removeClass('hide-btn').addClass('show-btn');
                            } else {
                                $('#' + id).text('{{__("label.inactive")}}').removeClass('show-btn').addClass('hide-btn');
                            }
                            toastr.success(resp.success);
                        } else {
                            toastr.error(resp.errors);
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        };
    </script>
@endsection